#include "board.h"

#include <stdbool.h>
#include <stdint.h>

/**
 * Funktionsprototypen / Function prototypes
 */
void _ConfigureTc(void);
void TC0_IrqHandler(void);
void _Wait(unsigned long);

/**
 * Variablen / Variables
 */
volatile uint32_t dwTimeStamp = 0;

/**
 * Externe Referenzen / External references
 */
extern bool bLed1Active;

/**
 * Konfiguration von Timer Counter 0 /
 * Configuration of Timer Counter 0
 */
void _ConfigureTc(void)
{

	uint32_t div;
	uint32_t tcclicks;

	// Enable peripheral clock
	PMC->PMC_PCER0 = 1 << ID_TC0;

	// Configure TC for a 4 Hz frequency and trigger on RC compare
	TC_FindMckDivisor(4, BOARD_MCK, &div, &tcclicks, BOARD_MCK);
	TC_Configure(TC0, 0, tcclicks | TC_CMR_CPCTRG);
	TC0->TC_CHANNEL[0].TC_RC = (BOARD_MCK / div) / 4;

	// Configure and enable interrupt on RC compare
	NVIC_EnableIRQ((IRQn_Type) ID_TC0);
	TC0->TC_CHANNEL[0].TC_IER = TC_IER_CPCS;

	// Start the counter if LED1 is enabled
	if (bLed1Active)
	{
		TC_Start(TC0, 0);
	}
}

/**
 * Interrupt-Serviceroutine f. den TC0-Interrupt. Wechselt den Zustand von LED #1.
 * IRQ handler for the TC0 interrupt. Toggles the state of LED #1.
 */
void TC0_IrqHandler(void)
{
	volatile uint32_t dummy;

	// Setze Status-Bit zurueck als Zeichen, dass der Interrupt behandelt wird.
	// Reset the status bit to acknowledge interrupt.
	dummy = TC0->TC_CHANNEL[0].TC_SR;

	// Zustandswechsel von LED #1
	// Toggle LED #1 state.
	LED_Toggle(1);
	printf("\r\n");
	printf("1 ");
}

void SysTick_Handler(void)
{
	dwTimeStamp++;
}

void _Wait(unsigned long delay)
{
	volatile uint32_t start = dwTimeStamp;
	uint32_t elapsed;

	do
	{
		elapsed = dwTimeStamp;
		elapsed -= start;
	} while (elapsed < delay);
}

// EOF
