/**
 * File	  : main.c
 * Author : Ralf Jesse
 * Date	  : 12.07.2013
 *
 * \brief
 *
 */


/**
 * Header files
 */
#include "board.h"
#include <stdio.h>
#include <stdint.h>
#include "buttons.h"

/**
 * Externe Referenzen
 */
extern void    ConfigureButtons(void);
extern uint8_t pa0_Status;

/**
 * Definitionen
 */
#define PIO_IRQ_PRIO    0


/**
 * Funktions-Prototypen
 */
void delayMillis(uint32_t);


/**
 * main
 *
 * @param  none
 * @return int
 *
 * \brief
 */
int main()
{
	WDT_Disable(WDT);

	PIO_InitializeInterrupts(PIO_IRQ_PRIO);
	ConfigureButtons();


	while (1)
	{
		// Ermittelt aktuellen Data-Status von PA0
		pa0_Status = REG_PIOA_PDSR & PA0_HIGH;
	}

	return 0;
}


/**
 * Delay_Millis
 *
 * @param  uint32_t  Verweildauer in Millisekunden
 * @return none
 *
 * \brief  Einfache Funktion zum Einstellen der Wartezeit in Millisekunden.
 */
void delayMillis(uint32_t millis)
{
	// Faktor 3000 durch Probieren ermittelt
	uint32_t delay = millis * 3000;

	while(delay--)
		;
}


// EOF


