/**
 * Autor / Author: Ralf Jesse
 * Datum / Date  : 12.07.2013
 */

/**
 * Header-Dateien / Header files
 */
#include "board.h"
#include <stdbool.h>

#include "buttons.h"

/**
 * Funktions-Prototypen
 */
void        ConfigureButtons(void);
static void button1_Handler(const Pin *pPin);
static void button2_Handler(const Pin *pPin);
static void ProcessButtonEvent(char *);

// Push buttons
const Pin pinPB1 = BUTTON_1;
const Pin pinPB2 = BUTTON_2;

// Output PA0
const Pin outPin = OUTPUT_PA0;

// Globale Variablen
uint8_t pa0_Status;


/**
 * Externe Referenzen
 */

/**
 * ConfigureButtons
 *
 * @param  none
 * @return none
 *
 * \brief Konfiguration der Pushbuttons.
 *
 */
void ConfigureButtons(void)
{
	// Konfiguration der PIOs
	PIO_Configure(&outPin, 1);
	PIO_Configure(&pinPB1, 1);
	PIO_Configure(&pinPB2, 1);

	// Entprellen nur fuer Button_2 (10 Hz)
	PIO_SetDebounceFilter(&pinPB2, 10);

	// Initialisiert die PIO-Interrupt-Handler (definiert in 'board.h')
	PIO_ConfigureIt(&pinPB1, button1_Handler);
	PIO_ConfigureIt(&pinPB2, button2_Handler);

	// Freigabe der PIO-Controller-Interrupts
	NVIC_EnableIRQ((IRQn_Type) pinPB1.id);
	NVIC_EnableIRQ((IRQn_Type) pinPB2.id);

	// Aktivieren der PIO-Anschluss-Interrupts
	PIO_EnableIt(&pinPB1);
	PIO_EnableIt(&pinPB2);
}


/**
 * button1_Handler
 *
 * @param  const Pin Pointer
 * @return none
 *
 */
static void button1_Handler(const Pin *pPin)
{
	if (pPin == &pinPB1)
		ProcessButtonEvent("PB1");
}

/**
 * button2_Handler
 *
 * @param  const Pin Pointer
 * @return none

 */
static void button2_Handler(const Pin *pPin)
{
	if (pPin == &pinPB2)
		ProcessButtonEvent("PB2");
}

/**
 * ProcessButtonEvent
 *
 * @param  char* button
 * @return none
 *
 * \brief Toggelt den Output PA0
 *
 *
 */
static void ProcessButtonEvent(char *button)
{
	// Toggelt den Data-Status von PA0
	printf("PA0 alter Status = %d\r\n", pa0_Status);

	if (pa0_Status == PA0_LOW)
        PIO_Set(&outPin);
    else
    	PIO_Clear(&outPin);

	printf("%s betaetigt\r\n", button);
	printf("\r\n");
}


// EOF
