/*
 * buttons.h
 *
 *  Created on: 12.07.2013
 *      Author: Ralf Jesse
 */

#ifndef BUTTONS_H_
#define BUTTONS_H_

// Port-Definitionen
// OUTPUT_PA0 : Output mit einem Default-Level von 0
// BUTTON_1   : Input, Interrupt 'Steigende Flanke', Debounce-Filter deaktiviert
// BUTTON_2   : Input, Interrupt 'Steigende Flanke', Debounce-Filter aktiviert
#define OUTPUT_PA0  { PIO_PA0,  PIOA, ID_PIOA, PIO_OUTPUT_0, PIO_PULLUP }
#define BUTTON_1    { PIO_PA19, PIOA, ID_PIOA, PIO_INPUT, PIO_PULLUP | PIO_IT_RISE_EDGE }
#define BUTTON_2    { PIO_PA20, PIOA, ID_PIOA, PIO_INPUT, PIO_PULLUP | PIO_DEBOUNCE | PIO_IT_RISE_EDGE }

// Output-Status
#define PA0_OFF       0x00000000
#define PA0_ON        0x00000001
#define PA0_MASK      0x00000001

#define PB1           0
#define PB2           1
#define NO_BUTTON     2

#define PA0_LOW       0
#define PA0_HIGH      1

#endif /* BUTTONS_H_ */
