/**
 * rtc_timer.c
 *
 *  Created on: 30.10.2013
 *      Author: ralf
 *
 * \brief
 */


#include <stdio.h>
#include <stdbool.h>

#include "board.h"
#include "chip.h"
#include "global.h"

void Configure_RTC(void)
{
    RTC_SetHourMode(RTC, MODE_24H);

    NVIC_DisableIRQ(RTC_IRQn);
    NVIC_ClearPendingIRQ(RTC_IRQn);
    NVIC_SetPriority(RTC_IRQn, IRQ_PRIOR_PIO);
    NVIC_EnableIRQ(RTC_IRQn);

    RTC_EnableIt(RTC, RTC_IER_SECEN);
}

void RTC_IrqHandler(void)
{
    uint32_t rtcStatus = RTC->RTC_SR;

    if ((rtcStatus & RTC_SR_SEC) == RTC_SR_SEC)
    {
        RTC_DisableIt(RTC, RTC_IDR_SECDIS);

        secondEvent = true;

        RTC_ClearSCCR(RTC, RTC_SCCR_SECCLR);
        RTC_EnableIt(RTC, RTC_IER_SECEN);
    }
}

// EOF
