/*
 * global.h
 *
 *  Created on: 23.09.2013
 *      Author: ralf
 */

#ifndef GLOBAL_H_
#define GLOBAL_H_

#include <stdio.h>
#include <stdbool.h>
#include <stdint.h>


/**
 * Funktions-Prototypen
 */
extern void     Configure_Buttons(void);
extern void     Configure_RTC(void);
extern void     PB_Handler(const Pin *);
extern void     convertTimeToString(uint8_t *, uint8_t *, uint8_t *);
extern void     convertDateToString(uint16_t *, uint8_t *, uint8_t *, uint8_t *);
extern void     setClockTime(uint32_t, uint8_t, uint8_t, uint8_t);
extern void     setAlarmTime(uint32_t, uint8_t, uint8_t, uint8_t);
extern void     setCalendarDate(uint16_t year, uint8_t month, uint8_t day, uint8_t dow);
extern void     setAlarmDate(void);
extern uint8_t  setNewState(void);
extern void     delayMillis(uint32_t);
extern void     delayMikros(uint32_t);

// ZUM DEBUGGEN
extern void      hex2bin(char *, unsigned int);


// Allgemeine Definitionen
#define IRQ_PRIOR_PIO    0


// Meldungen (Status und Fehler) des Programms
#define SYSTICK_CONFIGURATION_ERROR           -100


/**
 * Definitionen fr die Statusmaschine
 */
// Hauptmen
#define STATE_NORMAL_RUN                      0    // Normalbetrieb
#define STATE_SET_RTC                         1    // RTC-Modus aktivieren
#define STATE_SET_CLOCK                       2    // Auswahl: Uhrzeit/Weckzeit
#define STATE_SET_DATE                        3    // Auswahl: Kalender/Alarmkalender

#define STATE_SET_NORMAL_CLOCK                4    // Uhrentyp --> Normale Uhr
#define STATE_SET_ALARM_CLOCK                 5    // Uhrentyp --> Wecker
#define STATE_SET_CLOCK_TYPE                  6    // Auswahl : 'Normale Uhr' / Wecker
#define STATE_SET_CLOCK_MODE                  7    // Uhr     : Modus 12h/24h,
                                                   //           Genutzt f. Uhrzeit + Weckzeit
#define STATE_SET_NORMAL_DATE                 8
#define STATE_SET_ALARM_DATE                  9

#define STATE_SET_CENTURY                    10
#define STATE_SET_YEAR                       11
#define STATE_SET_MONTH                      12
#define STATE_SET_DAY                        13
#define STATE_SET_DAY_OF_WEEK                14
#define STATE_SET_CALENDAR_DONE              15




//#define STATE_SET_CALENDAR_TYPE               3    // Auswahl : Kalender / Alarmdatum
//#define STATE_SET_TIME                        5    // Einst. Uhrzeit/Weckzeit
//
//// Einstellungen: Uhrzeit/Weckzeit
//#define STATE_SET_HOURS_AND_MINUTES           6    // Stunden
//#define STATE_CLOCK_SETUP_FINISHED            7    // Einst. Uhr abgeschlossen


/**
 * Definitionen zum Einstellen von Uhrzeit und Datum
 */
#define MODE_RTC_SET_CLOCK                    0
#define MODE_RTC_SET_DATE                     1
#define NORMAL_CLOCK                          0
#define ALARM_CLOCK                           1
#define NORMAL_DATE                           0
#define ALARM_DATE                            1

#define MODE_AM                               0
#define MODE_PM                               1
#define MODE_24H                              0
#define MODE_12H                              1

#define CENTURY_20                           19
#define CENTURY_21                           20
#define JANUARY                               1
#define FEBRUARY                              2
#define MARCH                                 3
#define APRIL                                 4
#define MAY                                   5
#define JUNE                                  6
#define JULY                                  7
#define AUGUST                                8
#define SEPTEMPER                             9
#define OCTOBER                              10
#define NOVEMBER                             11
#define DECEMBER                             12


// Variablen, die durch Interrupts verndert werden
volatile bool    rtcSetupStarted;

volatile bool    secondEvent;
volatile bool    alarmEvent;
volatile bool    alarmCanceled;

volatile bool    pb1Pressed;
volatile bool    pb2Pressed;
volatile uint8_t currentState;



/**
 * Allgemeine Variablen fr RTC
 */
uint8_t  rtcMode;          // Auswahl: Uhr oder Kalender?
uint8_t  clockType;        // Auswahl: Uhr oder Wecker?
uint8_t  calenderType;     // Auswahl: Kalender oder Alarmdatum?

uint32_t clockMode;        // 12-Stunden-/24-Stunden-Modus
uint8_t  ampmMode;         // Im 12-Stunden-Mode --> Umschalten zwischen AM/PM

uint8_t  hours;
uint8_t  hoursTenner;
uint8_t  hoursOnes;

uint8_t  minutes;
uint8_t  minutesTenner;
uint8_t  minutesOnes;

uint8_t  seconds;
uint8_t  secondsTenner;
uint8_t  secondsOnes;

bool     centurySetupDone;
uint8_t  dateCentury;
uint16_t dateYear;
uint8_t  dateMonth;
uint8_t  dateDay;
uint8_t  dateDayOfWeek;



/**
 * Spezielle Variablen fr Uhrzeit und Weckzeit
 */
uint8_t  hours;
uint8_t  minutes;
uint8_t  seconds;

uint8_t  clockHours;
uint8_t  clockMinutes;
uint8_t  clockSeconds;
uint8_t  alarmHours;
uint8_t  alarmMinutes;
uint8_t  alarmSeconds;

/**
 * Spezielle Variablen fr Kalender und Alarm-Kalender
 */
// Variablen fr den gregorianischen Kalender
uint16_t dateYear;
uint8_t  dateMonth;
uint8_t  dateDay;
uint8_t  dateDayOfWeek;

// Variablen fr den Alarm-Kalender
uint8_t  alarmMonth;
uint8_t  alarmDay;


// Globale Variablen fr das LC-Display
extern bool stateModeChanged;

extern char dateYearLCD[17];
extern char dateMonthLCD[17];
extern char dateDayLCD[17];

extern char currentTime[17];
extern char alarmClockTime[17];
extern char currentDate[17];
extern char alarmDate[17];

extern char months[12][5];
extern char days[7][3];


#endif /* GLOBAL_H_ */
