/**
 * rtc_helper.c
 *
 *  Created on: 30.10.2013
 *      Author: ralf
 *
 * \brief
 */

#include <stdio.h>
#include <stdbool.h>

#include "board.h"
#include "chip.h"
#include "global.h"


/**
 * convertTimeToString()
 *
 * \brief Hilfsfunktion zum Umwandeln der Uhrzeit/Weckzeit in ein char[],
 *        das fr die Anzeige auf dem LC-Display verwendet wird.
 *
 * @param  uint8_t *hours
 * @param  uint8_t *minutes
 * @param  uint8_t *seconds
 *
 * @return none
 */
void convertTimeToString(uint8_t *hours, uint8_t *minutes, uint8_t *seconds)
{
    hoursTenner    = *hours / 10;
    hoursOnes      = *hours % 10;
    minutesTenner  = *minutes / 10;
    minutesOnes    = *minutes % 10;
    secondsTenner  = *seconds / 10;
    secondsOnes    = *seconds % 10;

    currentTime[0] = hoursTenner + '0';
    currentTime[1] = hoursOnes + '0';
    currentTime[3] = minutesTenner + '0';
    currentTime[4] = minutesOnes + '0';
    currentTime[6] = secondsTenner + '0';
    currentTime[7] = secondsOnes + '0';
}

/**
 * convertDateToString()
 *
 * \brief Hilfsfunktion zum Umwandeln des Kalenderdatums in ein char[],
 *        das fr die Anzeige auf dem LC-Display verwendet wird.
 *
 * @param  uint8_t dateYear, hat immer die Form 20xx
 * @param  uint8_t dateMonth
 * @param  uint8_t dateDay
 * @param  uint8_t dateDayOfWeek
 *
 * @return none
 */
void convertDateToString(uint16_t *dateYear, uint8_t *dateMonth, uint8_t *dateDay, uint8_t *dateDayOfWeek)
{
	uint8_t i;

	// Wochentag aus char[] days
	for (i = 0; i < 2; i++)
        currentDate[0+i] = *(days[*dateDayOfWeek - 1] + i);

	// Tag aus dem RTC-Kalender
	currentDate[5]  = *dateDay / 10 + '0';
	currentDate[6]  = *dateDay % 10 + '0';

	// Monat aus dem RTC-Kalender
	currentDate[8]  = *dateMonth / 10 + '0';
	currentDate[9]  = *dateMonth % 10 + '0';

	// Jahr aus dem RTC-Kalender in der Form 20xx
	currentDate[13] = (*dateYear - 2000) / 10 + '0';
	currentDate[14] = (*dateYear - 2000) % 10 + '0';

	// Beim Stellen der Anzeige soll das letzte Datum verwendet werden
	dateYearLCD[ 7] = '2';
	dateYearLCD[ 8] = '0';
	dateYearLCD[ 9] = currentDate[13];
	dateYearLCD[10] = currentDate[14];

    for (i = 0; i < 4; i++)
        dateMonthLCD[7 + i] = *(months[*dateMonth - 1] + i);

	for (i = 0; i < 2; i++)
	    dateDayLCD[7 + i] = currentDate[0+i];

	dateDayLCD[12]  = currentDate[5];
	dateDayLCD[13]  = currentDate[6];

	// NULL-Zeichen am Ende nicht vergessen
	currentDate[16] = '\0';
}

// EOF
