#include <stdio.h>
#include <stdbool.h>

#include "global.h"


/**
 * void calcSawtoothData(void)
 *
 * \brief Berechnung der Daten des Saegezahnsignals. Nach der vorgegebenen
 *        Anzahl von Schritten soll der Saegezahn vollstaendig sein, d.h. die
 *        maximale Amplitude muss dann erreicht sein.
 *
 * param  none
 * return none
 */
void calcSawtoothData(void)
{
    float        deltaAmplitude = 1.0 * MAX_DIGITAL / tableSize;
    float        sawtooth = 0;             // Wert des Ausgangssignals
    unsigned int result;                   // dto., aber als unsigned int

    bool         sign = true;              // Immer positiv
    char         sawtoothAsCharArray[4];   // Fuer Bildschirmanzeige u. Datei
    int          i;                        // Groesse der Tabelle


    printf("deltaAmplitude = %f\r\n", deltaAmplitude);

    // Schleife zur Berechnung des Dreieck-Signals
    for (i = 0; i < tableSize; i++)
    {
        // 'Cast' float --> unsigned int
        result = (unsigned int) sawtooth;
        sawtooth += deltaAmplitude;

        // Umwandlung des float-Wertes in einen String
        sprintf(sawtoothAsCharArray, "%03X", result);
        sawtoothAsCharArray[3] = '\0';

        // Ausgabe auf Monitor
        printToScreen(sign, sawtoothAsCharArray, i, waveForm, tableSize);

        // Ausgabe in Datei
        printToFile(sign, sawtoothAsCharArray, i, waveForm, tableSize);
    }
}

