/*
 * global.h
 *
 *  Created on: 23.09.2013
 *      Author: ralf
 */

#ifndef GLOBAL_H_
#define GLOBAL_H_

#include <stdio.h>
#include <stdbool.h>
#include <stdint.h>


/**
 * Funktions-Prototypen
 */
extern void     delayMillis(uint32_t);
extern void     delayMikros(uint32_t);
extern void     ShowIntro(void);
extern void     ShowMenu(void);
extern void     generateSinus(uint16_t, uint16_t);
extern void     generateTriangle(void);
extern void     generateSawtooth(void);
extern uint32_t GetNumkey2Digit(void);
extern int16_t  get4Digits(uint16_t, uint16_t);


// Allgemeine Definitionen
#define IRQ_PRIOR_PIO    6
#define VT100_CLEARSCREEN    printf("%c[2J", 0x1b);
#define VT100_CURSOR_HOME    printf("%c[?6l", 0x1b);

// Definitionen fuer den Generator
#define SAMPLES            100
#define MAX_DIGITAL       4095
#define VOLT_REF          3300
#define F_LOWER             50
#define F_UPPER           2500
#define INVALID_VALUE    60000


// Form des Ausgangssignals
#define SINUS      0
#define TRIANGLE   1
#define SAWTOOTH   2


// Meldungen (Status und Fehler) des Programms
#define SYSTICK_CONFIGURATION_ERROR    -100

extern  int16_t  freq, amp;
extern  uint8_t  tableIndex;
extern  uint8_t  waveForm;
extern  uint16_t frequency;
extern  uint16_t amplitude;
extern  bool     msgShown;
extern  int8_t   sign;


extern const int16_t sinusData[];
extern const int16_t triangleData[];
extern const int16_t sawtoothData[];

volatile bool     systickToggle;
volatile bool     dacc_eoc_event;

#define  PIN_LED_RED  { PIO_PA0, PIOA, ID_PIOA, PIO_OUTPUT_0, PIO_DEFAULT }
#define  PIN_LED_GRN  { PIO_PA1, PIOA, ID_PIOA, PIO_OUTPUT_0, PIO_DEFAULT }


#endif /* GLOBAL_H_ */
