
#include "board.h"
#include "chip.h"
#include "global.h"
#include "a2d.h"
#include "hd44780.h"
#include "stringutil.h"
#include "mathutil.h"
#include "ntc.h"

#include <stdbool.h>
#include <stdint.h>
#include <stdio.h>
#include <string.h>
#include <assert.h>


// ADC-Puffer
int16_t adc_values[BUFFER_SIZE] = { 0 } ;
char    text[CHARS_PER_LINE] = "T=";
char    retVal[6]            = "";


int main( void )
{
    uint32_t i;
    int16_t  adcVal;
    uint8_t  lenText = 0;
    char     grad    = (char) 0xDFu;
    float    temperature;
    float    ratio;
    uint8_t  offset;


    // Watchdog deaktivieren
    WDT_Disable(WDT);

    // 10 s Timer
    SysTick_Config(BOARD_MCK / (100000));
    ADC_Configure();
    HD44780_Configure();

    lenText = strlen(text);

    while (1)
    {
        // Nach jeweils einer Sekunde wird getestet, ob die Konvertierung
    	// abgeschlossen ist.
        if (checkAdcRdy == true)
        {
            checkAdcRdy = false;
            ADC_CheckConversionStatus();
        }

        // Anzeige des gemessenen Wertes
        if (conversionDone)
        {
            for ( i = 0 ; i < BUFFER_SIZE ; i++ )
            {
                adcVal = adc_values[i] * VOLT_REF / MAX_DIGITAL;
                ratio = (float)adcVal / (float)MAX_DIGITAL;

                temperature = NtcRatioToTemperature(ratio) -273.15;

                offset = floatToCharArray(temperature, retVal);
                strcat(text, retVal);
                offset = strlen(text);
                text[offset++] = grad;
                text[offset++] = 'C';

                HD44780_PrintText(LCD_TEXT_LEFT, LCD_LINE_1, text);
                text[lenText] = '\0';
            }
            conversionDone = false ;
        }
    }

}

