/**
 * mathutil.c
 *
 *  Created on: 04.12.2013
 *      Author: ralf
 *
 * \brief
 */
#include "mathutil.h"

/**
 * int ipow (int base, int exp)
 *
 * \brief   Berechnung der Potenz zweier Integerwerte.
 *
 * @param   int base   (Basis)
 * @param   int exp    (Exponent)
 * @return  int result (result = base ^ exp)
 */
int ipow(int base, int exp)
{
    int result = 1;

    while (exp != 0)
    {
        if ((exp & 1) == 1)
            result *= base;

        exp >>= 1;
        base *= base;
    }

    return result;
}
