/**
* Berechnung der CRC7-Pruefsumme fuer das Polynom x^7 + x^3 + 1.
* Diese wird u.a. fuer MMC- und SD-Karten benoetigt.
*
* Dieses Beispiel basiert auf -->
* http://forums.parallax.com/showthread.php/127239-CRC7-Polynomial
*/

#include "calc_crc.h"

/**
 * int calc_crc7 (unsigned char*, int)
 *
 * \brief  Berechnet die CRC7-Pruefsumme fuer das angegebene Kommando und
 *         liefert diese an die aufrufende Funktion zurueck. Die Pruefsumme
 *         ist ein 7-Bit-Wert.
 *
 *         !!! ACHTUNG !!!
 *         Diese Funktion liefert nicht die "echte" Pruefsumme zurueck, sondern
 *         einen Wert, der bereits um eine Position nach links geschoben ist.
 *         Die frei gewordene Position Bit 0 wird dann auf '1' gesetzt und als
 *         Stoppbit verwendet.
 *
 *
 * @param  unsigned char *pc (Zeiger auf das Byte-Array mit dem Kommando)
 * @param  int           len (Laenge des Byte-Arrays in Byte)
 * @return int           crc (CRC7-Pruefsumme inkl. Stoppbit an Position Bit 0)
 */
uint8_t calc_crc7(unsigned char *pc, uint8_t len)
{
    uint8_t  i, c, crc;

    crc = 0;
    while (len-- > 0)
    {
        c = *pc++;
        for (i = 0; i < 8; i++)
        {
            crc <<= 1;
            if ((c ^ crc) & 0x80)
                crc ^= 0x09;

            c <<= 1;
        }
    }

    // Die CRC7-Pruefsumme ist sieben Bit lang. Durch das Verschieben
    // der Pruefsumme um eine Stelle nach links und die Addition von '1'
    // wird unmittelbar das Stoppbit hinzugefuegt.
    crc <<= 1;
    crc += 1;

    return ((unsigned char) crc);
}
