/**
 * spi_master.c
 *
 *  Created on: 29.12.2013
 *      Author: ralf
 *
 * \brief
 */
#include <stdint.h>

#include "board.h"
#include "global.h"
#include "spi_main.h"
#include "sdcard.h"


/**
 * void Init_SPI (void)
 *
 * \brief   Initialisierung und Konfiguration des SPI als Master.
 *
 * @param
 * @return  void
 */
void SPI_Init(void)
{
    PMC_EnablePeripheral(ID_SPI);               // SPI: Aktivierung des SCK

    // Konfiguration: SPI Mode Register, SPI_Configure() fuehrt intern 2x Reset des SPI durch!
    SPI_Configure(SPI, ID_SPI,
    		      SPI_MR_MSTR     |             // Verwende SPI als Master
                  SPI_MR_MODFDIS  |             // Deaktiviere Fehlererkennung
                  SPI_MR_PCS(0));               // Chip-Select-Leitungen sind direkt verbunden -->
                                                // CS0 = '0', CS1 bis CS3 = '1'

    // Konfiguration: SPI Chip Select Register
    SPI_ConfigureNPCS(SPI, 0, SPI_CSR_CPOL |    // CS ist aktiv bei Pegel '0'
                      SPI_CSR_CSNAAT       |    // CS inaktiv nach Transfer f. DLYBS/BOARD_MCK
                      SPI_CSR_BITS_8_BIT   |    // Datenwortlaenge = 8 Bit
                      SPI_CSR_SCBR(160)    |    // Taktfrequenz = BOARD_MCK / 160 = 400 kHz
                      SPI_CSR_DLYBS(0xFF));     // CS nicht aktiv fuer 0xFF/BOARD_MCK

    SPI_Enable(SPI);                            // SPI aktivieren
}


/**
 * void SPI_SendByte (uint8_t byte)
 *
 * \brief
 *
 * @param   uint8_t byte --> Byte, das gesendet werden soll
 * @return  none
 */
void SPI_SendByte(uint8_t byte)
{
    SPI->SPI_TDR = byte;
    while(!(SPI->SPI_SR & SPI_SR_TDRE));        // Warten, bis Datentransfer abgeschlossen
}

/**
 * uint8_t SPI_GetByte (void)
 *
 * \brief
 *
 * @param   none
 * @return  uint8_t
 */
uint8_t SPI_GetByte(void)
{
    SPI->SPI_TDR = 0xFF;                        // Dummy-Byte senden fuer Taktung
    while(!(SPI->SPI_SR & SPI_SR_RDRF));        // Warten, bis Datentransfer abgeschlossen

    return ((uint8_t) SPI->SPI_RDR);
}

// EOF (spi_main.c)
