/**
 * fatfs.c
 *
 *  Created on: 03.02.2014
 *      Author: ralf
 *
 * \brief
 */
#include <stdio.h>

#include "ff.h"
#include "ffconf.h"

/* lists directories and files in the selected path on the FAT file system */
void FAT_ListDirectory(char* path)
{
    FILINFO finfo;
    DIR dirs;

    /* list directories */
    if (f_opendir(&dirs, path) == FR_OK)
    {
        while ((f_readdir(&dirs, &finfo) == FR_OK) && finfo.fname[0])
        {
            if (finfo.fattrib & AM_DIR)
            {
                printf("<D>  ");
                printf((char*) &finfo.fname[0]);
                printf("\r\n");
            }
        }
    }

    /* list files */
    if (f_opendir(&dirs, path) == FR_OK)
    {
        while ((f_readdir(&dirs, &finfo) == FR_OK) && finfo.fname[0])
        {
            if (!(finfo.fattrib & AM_DIR))
            {
                printf("<F>  ");
                printf((char*) &finfo.fname[0]);
                printf("\r\n");
            }
        }
    }
}
