/**
 * File	  : main.c
 * Author : Ralf Jesse
 * Date	  : 06.05.2013
 *
 * \brief Ermittelt den Zustand der Ports nach einem Reset.
 *
 */


/**
 * Header files
 */
#include "board.h"
#include <stdio.h>
#include <stdint.h>


/**
 * Constants
 */


/**
 * External references
 */
extern void hex2bin(char *name, unsigned int val);

/**
 * Function prototypes
 */


int main ()
{
	WDT_Disable(WDT);

	// PIO-Status von PIOA, PIOB und PIOC
	hex2bin("REG_PIOA_PSR  ", (unsigned int) REG_PIOA_PSR);
	hex2bin("REG_PIOB_PSR  ", (unsigned int) REG_PIOB_PSR);
	hex2bin("REG_PIOC_PSR  ", (unsigned int) REG_PIOC_PSR);

	// Output-Status von PIOA, PIOB und PIOC
	printf("\r\n");
	hex2bin("REG_PIOA_OSR  ", (unsigned int) REG_PIOA_OSR);
	hex2bin("REG_PIOB_OSR  ", (unsigned int) REG_PIOB_OSR);
	hex2bin("REG_PIOC_OSR  ", (unsigned int) REG_PIOC_OSR);

	// Status der Pull-up-Widerstaende von PIOA, PIOB und PIOC
	printf("\r\n");
	hex2bin("REG_PIOA_PUSR ", (unsigned int) REG_PIOA_PUSR);
	hex2bin("REG_PIOB_PUSR ", (unsigned int) REG_PIOB_PUSR);
	hex2bin("REG_PIOC_PUSR ", (unsigned int) REG_PIOC_PUSR);

	// Status der Pull-down-Widerstaende von PIOA, PIOB und PIOC
	printf("\r\n");
	hex2bin("REG_PIOA_PPDSR", (unsigned int) REG_PIOA_PPDSR);
	hex2bin("REG_PIOB_PPDSR", (unsigned int) REG_PIOB_PPDSR);
	hex2bin("REG_PIOC_PPDSR", (unsigned int) REG_PIOC_PPDSR);

	while (1)
	{
		;
	}
}

// EOF


