/**
 * Projekt: 07_01_LCD
 *
 * File	  : main.c
 * Author : Ralf Jesse
 * Date	  : 29.10.2013
 *
 * \brief
 *
 */


/**
 * Header files
 */
#include <stdio.h>
#include <stdint.h>

#include "board.h"
#include "hd44780.h"
#include "global.h"


// Globale Variablen
char currentTime[17]    = "00:00:00        ";


int main ()
{
    secondEvent = false;

	// Watchdog deaktivieren
	WDT_Disable(WDT);

	// Erzeugung eines 10s-Taktes aus dem Systemtakt
    if (SysTick_Config(BOARD_MCK / 100000))
    {
        return SYSTICK_CONFIGURATION_ERROR;
    }

    // LCD: Initialisierung des LCD-Controllers
    HD44780_Configure();

    // Konfiguration der RTC
    Configure_RTC();

    while(1)
    {
        if (secondEvent == true)
        {
            secondEvent = false;
            RTC_GetTime(RTC, &hours, &minutes, &seconds);

            convertTimeToString(&hours, &minutes, &seconds);
            HD44780_PrintText(LCD_TEXT_LEFT, LCD_LINE_1, currentTime);
        }
    }
    return -1;
}

// EOF


