/*
 * global.h
 *
 *  Created on: 23.09.2013
 *      Author: ralf
 */

#ifndef GLOBAL_H_
#define GLOBAL_H_

#include <stdio.h>
#include <stdbool.h>
#include <stdint.h>

// Allgemeine Definitionen
#define IRQ_PRIOR_WDT      0
#define IRQ_PRIOR_PIO      5
#define WDT_TRIGGER_RESET  0
#define WDT_TRIGGER_IRQ    1
#define WDT_PERIOD         3000
#define WDT_RESET_PERIOD   2000

// Die LEDs des Atmel-Evaluierungsboards sind in board.h
// definiert. Wir haben die gelbe LED aus zwei Gruenden
// hier hinzugefuegt:
// 1. Die Bibliothek muss nicht neu erzeugt werden
// 2. Bei einem Update der Bibliotheken durch Atmel muss diese
//    Aenderung dort erneut durchgefuehrt werden.
#define LED_YELLOW         0

/**
 * Funktions-Prototypen
 */
extern void Configure_WDT(uint8_t);
extern void Configure_Ports(void);
extern void PB_Handler(const Pin *);
extern void Configure_Leds(void);


// Variablen, die durch Interrupts verndert werden
volatile bool     pb1Pressed;
volatile bool     pb2Pressed;
volatile uint32_t gSystick;
volatile bool     bLed0Active;
volatile bool     bLed1Active;


// Allgemeine Variablen
uint32_t wdtPeriod;
bool     sysTickEvent;


// Definitionen fuer das VT100-Terminal
#define VT100_CLEARSCREEN    printf("%c[2J", 0x1b);
#define VT100_CURSOR_HOME    printf("%c[?6l", 0x1b);

#endif /* GLOBAL_H_ */
