/**
 * terminal.c
 *
 *  Created on: 14.11.2013
 *      Author: ralf
 *
 * \brief
 */

#include <stdio.h>

#include "board.h"
#include "global.h"

/**
 * \brief Anzeige der Startinformationen
 */
void ShowIntro(void)
{
    VT100_CLEARSCREEN
    VT100_CURSOR_HOME
    printf("-- Beispiel fuer den DACC %s --\r\n", SOFTPACK_VERSION);
    printf("-- %s\r\n", BOARD_NAME);
    printf("-- Kompiliert: %s %s --\r\n", __DATE__, __TIME__);
}

/**
 * \brief Anzeige des Hauptmenues
 */
void ShowMenu(void)
{
	VT100_CLEARSCREEN
	VT100_CURSOR_HOME
    printf("\r\n");
    printf("================================================================\r\n");
    printf("Menue: Druecken Sie eine Taste, um die Konfiguration zu aendern.\r\n");
    printf("================================================================\r\n");
    printf("  1 : Sinus-Generator\r\n");
    printf("  2 : Saegezahn-Generator\r\n");
    printf("  3 : Dreieck-Generator\r\n");
    printf("  f : Frequenz (200Hz - 2500Hz)\r\n");
    printf("  a : Amplitude (100 - 2047)\r\n");
    printf("  i : Signal invertieren\r\n\r\n");
    printf("  m : Hauptmenue\r\n");
    printf("\r\n");
    printf("\r\n");
}

/**
 * \brief Eingabe: 2-stelliger numerischer Wert.
 *
 * \return numkey value
 */
uint32_t GetNumkey2Digit(void)
{
    uint32_t numkey;
    uint8_t key1, key2;

    printf("\r\n2 Ziffern eingeben : ");
#if defined (  __GNUC__  )
        fflush(stdout);
#endif
    key1 = UART_GetChar();
    printf("%c", key1);
    key2 = UART_GetChar();
    printf("%c", key2);
    printf("\r\n");

    numkey = (key1 - '0')*10 + (key2 - '0');

    return numkey;
}


/**
 * int16_t get4Digits (uint16_t, uint16_t)
 *
 * \brief
 *
 * @param
 * @return  void
 */
int16_t get4Digits(uint16_t lowerLimit, uint16_t upperLimit)
{
    uint8_t  i          = 0;
    uint8_t  strLength  = 0;
    uint8_t  input;
    uint8_t  inputString[4] = { 0 };
    uint16_t inputValue = 0;

    while (1)
    {
        input = UART_GetChar();

        if (input == '\n' || input == '\r')
        {
            printf("\r\n");
            break;
        }

        if ('0' <= input && '9' >= input)
        {
            printf("%c", input);
            inputString[i++] = input;

            if (i >= 4)
            {
                break;
            }
        }
    }

    // String muss mit '\0' abgeschlossen werden!
    inputString[i] = '\0';
    strLength  = i;
    inputValue = 0;

    for (i = 0; i < 4; i++)
    {
        if (inputString[i] != '0')
        {
            switch (strLength - i - 1)
            {
                case 0:
                    inputValue += (inputString[i] - '0');
                    break;

                case 1:
                	inputValue += (inputString[i] - '0') * 10;
                    break;

                case 2:
                	inputValue += (inputString[i] - '0') * 100;
                    break;

                case 3:
                	inputValue += (inputString[i] - '0') * 1000;
                    break;
            }
        }
    }

    if ((inputValue < lowerLimit) || (inputValue > upperLimit))
    {
        printf("Unzulaessige Eingabe\r\n");
        return INVALID_VALUE;
    }

    return inputValue;
}


// EOF
