/**
 * util.c
 * ======
 *
 * \brief Enthaelt Hilfsfunktionen zur String-Konvertierung und zur Ausgabe
 *        der Ergebnisse auf dem Bildschirm und in eine Datei.
 *
 *        Provides helper functions for the handling of string and to print
 *        the results to the screen, or into a file.
 *
 * Datum/Date  : 26.11.2013
 * Autor/Author: Ralf Jesse
 */
#include <stdio.h>
#include <stdbool.h>
#include <string.h>
#include <math.h>

#include "global.h"


/**
 * void printToScreen((bool sign, char *output, int count)
 *
 * \brief Ausgabe der berechneten Tabelle auf dem Bildschirm
 *
 * @param sign      : Vorzeichen
 * @param output    : Sinuswert
 * @param count     : Laufende Nummer
 * @param waveForm  : gewaehlte Signalform
 * @param tableSize : Anzahl der Elemente
 */
void printToScreen(bool sign, char *output, int count, int waveForm, int size)
{
    static bool oneShot = false;

    if (oneShot == false)
    {
        oneShot = true;

        switch (waveForm)
        {
            case SINUS:
                printf("const int16_t sinusData[SAMPLES] = \r\n");
                printf("{\r\n");
                break;

            case TRIANGLE:
                printf("const int16_t triangleData[SAMPLES] = \r\n");
                printf("{\r\n");
                break;

            case SAWTOOTH:
                printf("const int16_t sawtoothData[SAMPLES] = \r\n");
                printf("{\r\n");
                break;
        }
    }

    // Schreibt 10 Werte pro Reihe, dann Zeilenumbruch
    if ((count > 0) && ((count % 10) == 0))
        printf("\r\n");

    if (count % 50 == 0)
        printf("\r\n");

    // Vorzeichen ist positiv
    if (sign == true)
        printf("\t 0x");
    else // Vorzeichen ist negativ
        printf("\t-0x");

    printf(output);

    if (count < (tableSize - 1))
        printf("%c", ',');

    if (count == (tableSize - 1))
    {
        printf("\r\n};\r\n");
    }
}

/**
 * void printToFile(bool sign, char* wert)
 *
 * @param sign      : Vorzeichen
 * @param output    : Sinuswert
 * @param count     : Laufende Nummer
 * @param waveForm  : gewaehlte Signalform
 * @param tableSize : Anzahl der Elemente
 */
void printToFile(bool sign, char* output, int count, int waveForm, int size)
{
    static bool oneShot = false;

    if (oneShot == false)
    {
        oneShot = true;

        switch (waveForm)
        {
            case SINUS:
                fprintf(fp, "%s", "const int16_t sinusData[SAMPLES] = \n");
                fprintf(fp, "%s", "{");
                break;

            case TRIANGLE:
                fprintf(fp, "%s", "const int16_t triangleData[SAMPLES] = \n");
                fprintf(fp, "%s", "{");
                break;

            case SAWTOOTH:
                fprintf(fp, "%s", "const int16_t sawtoothData[SAMPLES] = \n");
                fprintf(fp, "%s", "{");
                break;
        }
    }

    // Schreibt 10 Werte pro Reihe, dann Zeilenumbruch
    if ((count > 0) && ((count % 10) == 0))
        fprintf(fp, "\n");

    if ((count % 50) == 0)
        fprintf(fp, "\n");

    // Vorzeichen ist positiv
    if (sign == true)
        fprintf(fp, "%s", "\t 0x");
    else // Vorzeichen ist negativ
        fprintf(fp, "%s", "\t-0x");

    fprintf(fp, output);

    if (count < (tableSize - 1))
        fprintf(fp, "%c", ',');

    if (count == (tableSize - 1))
        fprintf(fp, "%s", "\n};\n");
}

/**
 * char * stringToLowerCase(char *string)
 *
 * \brief Umwandlung einer Zeichenkette in Kleinbuchstaben
 *
 * @param  string
 * @return string (umgewandelt)
 */
char *stringToLowerCase(char *string)
{
    int i;
    int len = strlen(string);
    for (i = 0; i < len; i++)
    {
        if (string[i] >= 'A' && string[i] <= 'Z')
        {
            string[i] += 32;
        }
    }
    return string;
}

/**
 * int stringToNumber(char *string)
 *
 * \brief Wandelt einen String in einen Integerwert.
 *
 * @param  string
 * @return wert
 */
int stringToNumber(char *string)
{
    int value = 0;
    int i;
    int len = strlen(string);
    int currentChar;

    for (i = 0; i < len; i++)
    {
        currentChar = string[len - i - 1] - '0';

        if (currentChar >= 0 && currentChar < 10)
            value += (int) currentChar * pow(10, i);
        else
            return -1;
    }

    if ((value % 10) != 0)
    {
        value = (value / 10) * 10;
        roundDown = true;
    }

    return value;
}

// EOF (util.c)
