/**
 * main.c
 *
 *  Created on: 25.10.2013
 *      Author: ralf
 *
 * \brief
 */

// Allgemeine Header-Dateien
#include <stdio.h>

// Spezielle Header-Dateien fr das Entwicklungsboard und den Chip
#include "board.h"
#include "chip.h"

/**
 * M A I N - Funktion
 */
int main (void)
{
    // Watchdog-Timer deaktivieren
    WDT_Disable(WDT);

    printf("__TEMPLATE_SRAM_DEBUG_VERSION__ : Schablone fuer eigene Anwendungen\r\n");
    printf("\r\n");
    printf("\r\n");
    printf("Das Projekt '__TEMPLATE_SRAM_DEBUG_VERSION__' ist eine Schablone fuer das Anlegen\r\n");
    printf("eines neuen Software-Entwicklungsprojekts fuer den Mikrocontroller Atmel AT91SAM3S4B\r\n");
    printf("in Verbindung mit dem Evaluierungsboard Olimex SAM3-P256. Mit dieser Schablone erzeugte\r\n");
    printf("Projekte sind fuer das Debuggen waehrend der Entwicklung im SRAM ausgelegt.\r\n");
    printf("\r\n");
    printf("Anforderungen:\r\n");
    printf("   - IDE:        Eclipse IDE 4.3 for C/C++ Developers (Kepler, Service Release 1\r\n");
    printf("   - Toolchain:  Launchpad (GNU ARM Development Tools\r\n");
    printf("   - MinGW32:    Linux 'binutils' fuer Windows\r\n");
    printf("   - ICE:        Segger J-Link oder SAM-ICE Hardware Debugger / In-Circuit-Emulator\r\n");
    printf("   - GDB-Server: Segger J-Link GDB Server (mind. Version 4.62)\r\n");
    printf("   - SAM-BA:     SAM Boot Assistant (mind. Version 2.12)\r\n");
    printf("\r\n");
    printf("   - Erforderliche Eclipse-Plug-ins : \r\n");
    printf("        - C/C++ Development Tools SDK\r\n");
    printf("        - C/C++ Hardware Debugging\r\n");
    printf("        - C99 LR Parser\r\n");
    printf("        - GNU ARM C/C++ Cross Compiler Support\r\n");
    printf("\r\n");
    printf("   - Optionale Eclipse-Plug-ins:\r\n");
    printf("        - Subversive SVN Team Provider (oder anderes Versionierungstool)\r\n");
    printf("        - Subversive SVN Connectors\r\n");
    printf("\r\n");
    printf("Anwendung:\r\n");
    printf("   1. Eclipse Project Explorer --> New C Project\r\n");
    printf("   2. Neues Projekt --> Mausklick rechts --> Import\r\n");
    printf("   3. Muster '__TEMPLATE_SRAM_DEBUG_VERSION__' auswaehlen --> OK\r\n");
    printf("   4. Alle Dateien ueberschreiben\r\n");
    printf("   5. Eclipse Project Explorer --> Build\r\n");
    printf("\r\n");
    printf("Weitere Infos:\r\n");
    printf("Das neue Projekt 'erbt' saemtliche Einstellungen von '__TEMPLATE_SRAM_DEBUG_VERSION__',\r\n");
    printf("d.h. es enthaelt alle Compiler-, Linker- und Debugger-Einstellungen (Optionen, Header-\r\n");
    printf("Dateien, Bibliotheken, Launch-Informationen fuer den Debugger usw.). Darueber hinaus\r\n");
    printf("wird neben der resultierenden *.elf-Datei auch noch die entsprechende *.bin-Datei fuer\r\n");
    printf("die Uebertragung der Binaries mit SAM-BA erzeugt.\r\n");


    while (1)
    {
        ;
    }

    return -1;
}
