#ifndef MAX7219_TEST_H_INCLUDED
#define MAX7219_TEST_H_INCLUDED

#include "keyboard.h"

/**
 * Register des MAXIM 7219
 */
#define MAX7219_NOOP        ((uint8_t) 0x00)
#define MAX7219_DIG0        ((uint8_t) 0x01)
#define MAX7219_DIG1        ((uint8_t) 0x02)
#define MAX7219_DIG2        ((uint8_t) 0x03)
#define MAX7219_DIG3        ((uint8_t) 0x04)
#define MAX7219_DIG4        ((uint8_t) 0x05)
#define MAX7219_DIG5        ((uint8_t) 0x06)
#define MAX7219_DIG6        ((uint8_t) 0x07)
#define MAX7219_DIG7        ((uint8_t) 0x08)
#define MAX7219_DECODEMODE  ((uint8_t) 0x09)
#define MAX7219_INTENSITY   ((uint8_t) 0x0A)
#define MAX7219_SCANLIMIT   ((uint8_t) 0x0B)
#define MAX7219_OPMODE      ((uint8_t) 0x0C)
#define MAX7219_DISPTEST    ((uint8_t) 0x0F)

/**
 * Betriebsarten
 */
#define OPMODE_SHUTDOWN 0x00
#define OPMODE_NORMAL   0x01
#define OFF             0x00
#define ON              0x01

// Allgemeine Definitionen
#define GPIOS_USED       3
#define GPIO_OFFSET     23
#define GPIO23_DIN      23
#define GPIO24_LOAD     24
#define GPIO25_CLK      25

#define MAX7219_SET_LOAD_HIGH   1<<12 | 0x01
#define MAX7219_SET_LOAD_LOW    1<<12 & 0x00

#define DEVICE_NAME     "max7219"
#define LOW             0
#define HIGH            1
#define NUM_MAX7219     1               // Anzahl der MAX7219-Bausteine

#define MAX7219_MIN_INTENSITY   0x00    // Minimale Helligkeit der LEDs
#define MAX7219_MAX_INTENSITY   0x0F    // Maximale Helligkeit der LEDs
#define MAX7219_MED_INTENSITY   0x07    // Mittlere Helligkeit der LEDs

#define MAX7219_DECODE_OFF      0x00
#define MAX7219_DECODE_ON       0x01

#define MAX7219_SCAN_DIG_0      0x00
#define MAX7219_SCAN_DIG_0_1    0x01
#define MAX7219_SCAN_DIG_0_2    0x02
#define MAX7219_SCAN_DIG_0_3    0x03
#define MAX7219_SCAN_DIG_0_4    0x04
#define MAX7219_SCAN_DIG_0_5    0x05
#define MAX7219_SCAN_DIG_0_6    0x06
#define MAX7219_SCAN_DIG_0_7    0x07

// Komfortfunktionen
#define MAX7219_SETNUM          0x10;
#define MAX7219_SHOW_BITMAP     0x11;

// Fehlercodes
#define ERR_MAX7219_NOT_INITIALIZED 1000
#define ERR_MAX7219_INVALID_ARG     1001


// Allgemeine Variablen
int             fd_gpio;
uint8_t         data[8 * NUM_MAX7219];
static  uint8_t max7219_init_done = 0;

// Funktionsprototypen
void max7219_init (int, uint8_t, uint8_t, uint8_t, uint8_t, uint8_t);
int  max7219_set_num (int, uint8_t);
int  max7219_set_op_mode (int, uint8_t, uint8_t);
int  max7219_exec_matrix_test (int, uint8_t, uint8_t);
int  max7219_set_intensity (int, uint8_t, uint8_t);
int  max7219_set_decode_mode (int, uint8_t, uint8_t);
int  max7219_set_scan_limit (int, uint8_t, uint8_t);
int  max7219_show_bitmap (int, uint8_t, uint8_t);
int  max7219_scroll_bitmap (int, uint8_t, uint8_t, uint8_t *);
int  max7219_spread_bitmap (int, uint8_t, uint8_t, uint8_t, uint8_t, uint8_t);
int  max7219_shrink_bitmap (int, uint8_t, uint8_t, uint8_t, uint8_t, uint8_t);


#endif // MAX7219_TEST_H_INCLUDED
