#!/bin/bash

#########################################################################
# loopcnt2 [-u] [-d] endwert                
# 
# Einfaches Shell-Script zum Hochzaehlen bis zu einem vorgegebenen Wert
# bzw. zum Herunterzaehlen von einem vorgegebenen Wert bis auf 0. Das
# Zaehlen wird durch die Funktion count() durchgefuehrt. loopcnt erwartet
# genau zwei Argumente. Weitere Argumente werden ignoriert.
#
# Aenderungen:
# + Erweiterung der Funktionen 'countup' und 'countdown' um den Ganzzahl-
#   test fuer Argument 2.
#
# Optionen:
# -u : Hochzaehlen (count up)
# -d : Runterzaehlen (count down)
#
# Version: 0.2
# Autor  : RJ
#########################################################################

# !!! In Shell-Scripts muessen Funktionen VOR ihrer ersten Verwendung definiert werden !!!

# Definition der Funktion usage()
usage ()
{
    echo Die korrekte Syntax lautet: loopcnt [-u, [-d]] endwert
    exit 1
}

# Definition der Funktion countup()
countup ()
{
    if [ -z "$2" ]
    then
        echo Kein Startwert angegeben.
        usage
        exit 2
    fi

    # Testen, ob $2 ein numerischer Wert ist
    if [ "$2" -eq "$2" 2>/dev/null ]
    then
        # "$2" ist eine Ganzzahl, keine Aktion erforderlich.
        echo > /dev/null
    else
        echo Argument "$2" ist keine Ganzzahl.
        usage
        exit 3
    fi

    echo Maxwert = $2
    echo Countup fertig!
}

# Definition der Funktion countdown()
countdown ()
{
    if [ -z "$2" ]
    then
        echo Kein Startwert angegeben.
        exit 2
    fi

    # Testen, ob $2 ein numerischer Wert ist
    if [ "$2" -eq "$2" 2>/dev/null ]
    then
        # "$2" ist eine Ganzzahl, keine Aktion erforderlich.
        echo > /dev/null
    else
        echo Argument "$2" ist keine Ganzzahl.
        usage
        exit 3
    fi

    echo Startwert = $2
    echo Countdown fertig!
}

# Definition der Funktion usage()
usage ()
{
    echo Die korrekte Syntax lautet: loopcnt [-u, [-d]] endwert
    exit 1
}

#-------------------------------------------------------
# Hier beginnt das >eigentliche< Shell-Script
#-------------------------------------------------------

# Anzahl der Argumente ermitteln
if [ $# -lt 2 ]
then (
    echo Fehler bei der Anzahl der Argumente!
    exit 1
)
fi

# Wert der Argumente testen
if [ "$1" = "-u" ]
then
    # Mit 'expr $2' wird das zweite Argument in einen Zahlenwert umgewandelt.
    countup expr $2
    exit 0
elif [ "$1" = "-d" ]
then
    # Mit 'expr $2' wird das zweite Argument in einen Zahlenwert umgewandelt.
    countdown expr $2
    exit 0
else
    echo Ungueltiger Parameter "$1"
    usage
fi

