#!/bin/bash -e

#########################################################################
# loopcnt4 [-u] [-d] endwert                
# 
# Optionen:
# -u : Hochzaehlen (count up)
# -d : Runterzaehlen (count down)
#
# Version: 0.1
# Autor  : RJ
#########################################################################

source ./helper/checkint

# !!! In Shell-Scripts muessen Funktionen VOR ihrer ersten Verwendung definiert werden !!!

# Definition der Funktion countup()
countup ()
{
    if [ -z "$2" ]
    then
        echo Kein Startwert angegeben.
        usage
        exit 2
    fi

    isnumber $2

    echo Maxwert = $2
    echo Countup fertig!
    exit 0
}

# Definition der Funktion countdown()
countdown ()
{
    if [ -z "$2" ]
    then
        echo Kein Startwert angegeben.
        usage
        exit 2
    fi
    
    isnumber $2

    echo Startwert = $2
    echo Countdown fertig!
    exit 0
}

#-------------------------------------------------------
# Hier beginnt das >eigentliche< Shell-Script
#-------------------------------------------------------

# Anzahl der Argumente ermitteln
if [ $# -lt 2 ]
then
    echo Fehler bei der Anzahl der Argumente!
    usage
fi

# Wert der Argumente testen
if [ "$1" = "-u" ]
then
    # Mit 'expr $2' wird das zweite Argument in einen Zahlenwert umgewandelt.
    countup expr $2
    exit 0
elif [ "$1" = "-d" ]
then
    # Mit 'expr $2' wird das zweite Argument in einen Zahlenwert umgewandelt.
    countdown expr $2
    exit 0
else
    echo Das erste Argument muss -u oder -d sein.
    usage
fi

