#!/bin/bash

#########################################################################
# loopcnt3 [-u] [-d] endwert                
# 
# Modifizierte Variante von loopcnt2 mit externen Funktionen.
#
# Aenderungen:
# + Auslagerung der Funktion 'usage' nach 'helper/checkint.sh'.
# + Auslagerung des Ganzzahltests in die Funktion 'isnumber' in 'helper/checkint.sh'.
#
# Optionen:
# -u : Hochzaehlen (count up)
# -d : Runterzaehlen (count down)
#
# Version: 0.3
# Autor  : RJ
#########################################################################

# !!! In Shell-Scripts muessen Funktionen VOR ihrer ersten Verwendung definiert werden !!!
source helper/checkint.sh

# Definition der Funktion countup()
countup ()
{
    if [ -z "$2" ]
    then
        echo Kein Startwert angegeben.
        usage
        exit 2
    fi

    # Testen, ob $2 ein numerischer Wert ist
    isnumber $2
	
    echo Maxwert = $2
    echo Countup fertig!
}

# Definition der Funktion countdown()
countdown ()
{
    if [ -z "$2" ]
    then
        echo Kein Startwert angegeben.
        exit 2
    fi

    # Testen, ob $2 ein numerischer Wert ist
    isnumber $2
	
    echo Startwert = $2
    echo Countdown fertig!
}

#-------------------------------------------------------
# Hier beginnt das >eigentliche< Shell-Script.
#-------------------------------------------------------

# Anzahl der Argumente ermitteln
if [ $# -lt 2 ]
then (
    echo Fehler bei der Anzahl der Argumente!
    exit 1
)
fi

# Wert der Argumente testen
if [ "$1" = "-u" ]
then
    # Mit 'expr $2' wird das zweite Argument in einen Zahlenwert umgewandelt.
    countup expr $2
    exit 0
elif [ "$1" = "-d" ]
then
    # Mit 'expr $2' wird das zweite Argument in einen Zahlenwert umgewandelt.
    countdown expr $2
    exit 0
else
    echo Ungueltiger Parameter "$1"
    usage
fi

