#ifndef GPIO_PI_H_INCLUDED
#define GPIO_PI_H_INCLUDED

/* Definition ON/OFF */
#define OFF          0
#define ON           1

/* Modul-globale Variablen */
static        dev_t   fastgpio_dev_num;
static struct cdev   *driver_object;
static struct class  *fastgpio_class;
static struct device *fastgpio_dev;

/* Funktionsprototypen */
static int __init mod_init (void);
static void __exit mod_exit (void);
static int driver_open (struct inode *, struct file *);
static int driver_close (struct inode *, struct file *);
static ssize_t driver_write (struct file *, const char __user *, size_t, loff_t *);

/* file_operations-Struktur */
static struct file_operations fops =
{
    owner   : THIS_MODULE,
    open    : driver_open,
    release : driver_close,
    write   : driver_write
};

#endif // GPIO_PI_H_INCLUDED
