/**
 ******************************************************************************
 * @file           : main.c
 * @author         : Auto-generated by STM32CubeIDE
 * @brief          : Main program body
 ******************************************************************************
 * @attention
 *
 * <h2><center>&copy; Copyright (c) 2021 STMicroelectronics.
 * All rights reserved.</center></h2>
 *
 * This software component is licensed by ST under BSD 3-Clause license,
 * the "License"; You may not use this file except in compliance with the
 * License. You may obtain a copy of the License at:
 *                        opensource.org/licenses/BSD-3-Clause
 *
 ******************************************************************************
 */

#include <stm32f4xx.h>
#include <stdint.h>
#include <stdbool.h>

#include <mcalGPIO.h>
#include <mcalUsart.h>

#if !defined(__SOFT_FP__) && defined(__ARM_FP)
  #warning "FPU is not initialized, but the project is compiling for an FPU. Please initialize the FPU before use."
#endif


void uartTest(void);
void USART2_IRQHandler(void);

uint8_t *outString = (uint8_t *) "The quick brown fox jumps over the lazy dog. ";
uint8_t *saveString;

#define CR      (0x0D)      // Carriage return
#define LF      (0x0A)      // Line feed

int main(void)
{
    saveString = outString;                                             // NEU!

    // Konfiguration + Initialisierung von GPIOA
    gpioSelectPort(GPIOA);                                              // GPIOA: Bustakt aktivieren
    gpioSelectPinMode(GPIOA, PIN5, OUTPUT);                             // GPIOA/PIN5: Ansteuerung der Onboard-LED
    gpioSelectPinMode(GPIOA, PIN2, ALTFUNC);                            // GPIOA/PIN2: Alt. Funktion
    gpioSelectAltFunc(GPIOA, PIN2, AF7);                                // AF7 = USART2 Rx
    gpioSelectPinMode(GPIOA, PIN3, ALTFUNC);                            // GPIOA/PIN3: Alt. Funktion
    gpioSelectAltFunc(GPIOA, PIN3, AF7);                                // AF7 = USART2 Tx

    // Konfiguration von USART2
    usartSelectUsart(USART2);                                           // USART2: Bustakt aktivieren
    usartSetCommParams(USART2, 115200, NO_PARITY, LEN_8BIT, ONE_BIT);   // MCAL-Komfortfunktion
    usartEnableIrq(USART2, USART_IRQ_RXNEIE);                           // USART2: Receive-Interrupt aktivieren
    usartStartUsart(USART2);                                            // USART2: Starten

    NVIC_EnableIRQ(USART2_IRQn);

    /* Loop forever */
    while(1)
    {

    }
}

void USART2_IRQHandler(void)
{
    uint16_t received = 0;

    if (USART2->SR & USART_SR_RXNE)
    {
        received = USART2->DR & 0x01FF;
        if (received == 'a')
        {
            gpioSetPin(GPIOA, PIN5);                                    // GPIOA Bit5 in ODR --> 1
        }
        if (received == 'b')
        {
            gpioResetPin(GPIOA, PIN5);                                  // GPIOA Bit5 in ODR --> 0
        }

		/* Filter fuer zulaessige Zeichen */
        if (((received >= 'A') && (received <= 'Z')) || ((received >= 'a') && (received <= 'z')) ||
             (received == ' ') || (received == CR) || (received == LF) || (received == '*'))
        {
            USART2->DR = received;
        }
        if (received == 'c')
        {
            usartEnableIrq(USART2, USART_IRQ_TXEIE);                    // Tx-Interrupt nur aktivieren, wenn Daten gesendet werden sollen!
        }
    }

    if ((USART2->SR & USART_SR_TXE) && (USART2->CR1 & USART_CR1_TXEIE))
    {
        if (*outString != '\0')
        {
            USART2->DR = *outString++;                                  // Text zeichenweise ausgeben, bis das 0-Byte (= Textende) erkannt wird
        }
        else                                                            // 0-Byte gefunden --> Text wurde vollstaendig ausgegeben
        {
            outString = saveString;                                     // Neu: Urspruenglichen Text wieder herstellen
          USART2->CR1 &= ~USART_CR1_TXEIE;
        }
    }
}

