/**
 ******************************************************************************
 * @file           : main.c
 * @author         : Auto-generated by STM32CubeIDE
 * @brief          : Main program body
 ******************************************************************************
 * @attention
 *
 * <h2><center>&copy; Copyright (c) 2021 STMicroelectronics.
 * All rights reserved.</center></h2>
 *
 * This software component is licensed by ST under BSD 3-Clause license,
 * the "License"; You may not use this file except in compliance with the
 * License. You may obtain a copy of the License at:
 *                        opensource.org/licenses/BSD-3-Clause
 *
 ******************************************************************************
 */

/**
 * Der STM32F446 wird hier mit 160 MHz getaktet. Die Taktfrequenz wurde so gewaehlt, damit die Berechnung der Periodendauer
 * "glatte" Werte ergibt. Hier wird Timer TIM2 verwendet, der an APB1 angeschlossen ist. Da APB1 mit 40 MHz getaktet wird
 * und der Prescaler von TIM2 auf 1 gesetzt wird, wird TIM2 ebenfalls mit 40 MHz getaktet. Das bedeutet, dass er innerhalb
 * einer Sekunde bis 40.000.000	zaehlt (genau: 39.999.999, da der Wert 0 mitgezaehlt wird). Wird das Auto-Reload-Register
 * (ARR) auf den Wert 2 gesetzt, so toggelt TIMIO_CH1 alle 25 ns (Nanosekunden), die Periodendauer betraegt somit 50 ns,
 * was einer Frequenz von 20 MHz entspricht. Wird ARR auf 1 gesetzt, funktioniert es nicht mehr: TIMIO_CH1 bleibt dauerhaft
 * auf Low-Level.
 *
 * Um eine Periodendauer von 1 µs zu erreichen, muss hier nur das ARR auf den Wert 40 gesetzt werden, da 20 x 2 (Einstellung
 * des Prescalers des Timers) eine Periodendauer von 1 µs erzeugt.
 */

#include <stdint.h>
#include <stdbool.h>
#include <stdlib.h>

#include <stm32f4xx.h>
#include <system_stm32f4xx.h>

#include <mcalFlash.h>
#include <mcalRCC.h>
#include <mcalGPIO.h>
#include <mcalTimer.h>

#include <clockConfig.h>

int main(void)
{
	GPIO_TypeDef *port  = GPIOB;
	PIN_NUM_t     pin   = PIN8;
	TIM_TypeDef  *timer = TIM2;				// TIM2 ist an APB1 angeschlossen

    uint32_t sysClock  = 0UL;				// Die Variablen werden nur zur Kontrolle der Takteinstellung mit configClock()
    uint32_t apb1Clock = 0UL;				// verwendet und haben keine weitere Funktionalitaet.
    uint32_t apb2Clock = 0UL;

    configClock(160);						// MCU-Frequenz soll 160 MHz sein. Erleichtert die Berechnung der Timer-Periode.
    sysClock  = rccGetSysClock();			// MCU-Takt  = 160 MHz
    apb1Clock = rccGetPclk1Freq();			// APB1-Takt =  40 MHz
    apb2Clock = rccGetPclk2Freq();			// APB2-Takt =  80 MHz

	gpioSelectPort(port);
	gpioSelectPinMode(port, pin, ALTFUNC);
	gpioSelectAltFunc(port, pin, AF1);
	gpioSetOutputSpeed(port, pin, HIGH_SPEED);

	timerSelectTimer(timer);
	timerSetPrescaler(timer, 1);
	timerSetAutoReloadValue(timer, 40);

	timerSetOutputCompareMode(timer, TIMIO_CH1, CHN_TOGGLE_ON_MATCH);
    timerEnableOutputComparePreload(timer, TIMIO_CH1);
    timerEnableCaptureCompareChannel(timer, TIMIO_CH1);
    timerResetCounter(timer);
    timerEnableInterrupt(timer, TIM_CAPCOMP_IRQ_CH1);
    timerStartTimer(timer);


    NVIC_EnableIRQ(TIM2_IRQn);				// Hier muss der Interrupt für den Timer explizit aktiviert werden.

    /* Loop forever */
	while(1)
	{

	}
}

void TIM2_IRQHandler(void)
{
	static uint32_t dummy = 0UL;

	timerClearInterruptFlag(TIM2, TIM_CAPCOMP_IRQ_CH1);
	dummy++;
}
