/**
 * Projekt Kap08-SysTick-04-MCAL-Version
 * =====================================
 *
 * Dieses Beispiel soll zeigen, wie die MCAL-Funktionen hier verwendet werden
 * koennen. Die Funktion ist identisch mit Projekt Kap08-SysTick-04.
 */

/**
 ******************************************************************************
 * @file           : main.c
 * @author         : Auto-generated by STM32CubeIDE
 * @brief          : Main program body
 ******************************************************************************
 * @attention
 *
 * <h2><center>&copy; Copyright (c) 2019 STMicroelectronics.
 * All rights reserved.</center></h2>
 *
 * This software component is licensed by ST under BSD 3-Clause license,
 * the "License"; You may not use this file except in compliance with the
 * License. You may obtain a copy of the License at:
 *                        opensource.org/licenses/BSD-3-Clause
 *
 ******************************************************************************
 */

#if !defined(__SOFT_FP__) && defined(__ARM_FP)
  #warning "FPU is not initialized, but the project is compiling for an FPU. Please initialize the FPU before use."
#endif

#include <stm32f4xx.h>
#include <stdint.h>
#include <stdbool.h>

#include <mcalSysTick.h>
#include <mcalGPIO.h>

/**
 * Globale Variablen
 */
bool     timerTrigger = false;

/**
 * H A U P T P R O G R A M M
 */
int main(void)
{
    uint32_t pin0Timer = 0UL;
    uint32_t pin1Timer = 0UL;
    uint8_t  arraySize = 0;

    // Liste mit allen verwendeten Timer-Variablen
    uint32_t *timerList[] = { &pin0Timer, &pin1Timer };
    arraySize = sizeof(timerList)/sizeof(uint32_t);

    // MCAL: Initialisierung des SysTick-Timers
    systickInit(SYSTICK_1MS);
    systickSetMillis(&pin0Timer, 200);
    systickSetMillis(&pin1Timer, 400);

    // MCAL: Initialisierung der GPIOs
    gpioInitPort(GPIOA);
    gpioSelectPinMode(GPIOA, PIN0, OUTPUT);
    gpioSetOutputType(GPIOA, PIN0, PUSHPULL);
    gpioSelectPushPullType(GPIOA, PIN0, PULLUP);

    gpioSelectPinMode(GPIOA, PIN1, OUTPUT);
    gpioSetOutputType(GPIOA, PIN1, PUSHPULL);
    gpioSelectPushPullType(GPIOA, PIN1, PULLUP);

    while (1)
    {
        if (timerTrigger == true)
        {
            systickUpdateTimers((uint32_t *) timerList, arraySize);
        }

        if (isSystickExpired(pin0Timer))
        {
            gpioTogglePin(GPIOA, PIN0);
            systickSetMillis(&pin0Timer, 200);
        }

        if (isSystickExpired(pin1Timer))
        {
            gpioTogglePin(GPIOA, PIN1);
            systickSetMillis(&pin1Timer, 400);
        }
    }
}
