/**
 ******************************************************************************
 * @file           : main.c
 * @author         : Auto-generated by STM32CubeIDE
 * @brief          : Main program body
 ******************************************************************************
 * @attention
 *
 * <h2><center>&copy; Copyright (c) 2019 STMicroelectronics.
 * All rights reserved.</center></h2>
 *
 * This software component is licensed by ST under BSD 3-Clause license,
 * the "License"; You may not use this file except in compliance with the
 * License. You may obtain a copy of the License at:
 *                        opensource.org/licenses/BSD-3-Clause
 *
 ******************************************************************************
 */

#if !defined(__SOFT_FP__) && defined(__ARM_FP)
  #warning "FPU is not initialized, but the project is compiling for an FPU. Please initialize the FPU before use."
#endif

#include <stm32f4xx.h>
#include <stdint.h>
#include <stdbool.h>

#include <mcalGPIO.h>
#include <mcalTimer.h>

/**
 * Funktionsprototypen
 */
void TIM6_DAC_IRQHandler(void);

/**
 * Globale Variablen
 */
bool tim6Trigger = false;

int main(void)
{
    __disable_irq();

    gpioInitPort(GPIOA);
    gpioSelectPinMode(GPIOA, PIN0, OUTPUT);
    gpioSetOutputType(GPIOA, PIN0, PUSHPULL);
    gpioSelectPushPullType(GPIOA, PIN0, PULLUP);
    gpioSetOutputSpeed(GPIOA, PIN0, HIGH_SPEED);

    timerBusClkOn(TIM6);
    timerSetPrescaler(TIM6, (1600 - 1));
    timerSetAutoReloadValue(TIM6, (10000 - 1));
    timerEnableInterrupt(TIM6);
    timerStart(TIM6);

    NVIC_EnableIRQ(TIM6_DAC_IRQn);

    __enable_irq();

    while(1)
    {
        if (tim6Trigger == true)
        {
            gpioTogglePin(GPIOA, PIN0);
            tim6Trigger = false;
        }
    }
}

/**
 * ISR fuer Timer TIM6
 */
void TIM6_DAC_IRQHandler(void)
{
    tim6Trigger = true;
    TIM6->SR = 0;
}
