/**
 * Kap11-ACTIM-Center-And-Edge-Align
 *
 */
/**
 ******************************************************************************
 * @file           : main.c
 * @author         : Auto-generated by STM32CubeIDE
 * @brief          : Main program body
 ******************************************************************************
 * @attention
 *
 * <h2><center>&copy; Copyright (c) 2020 STMicroelectronics.
 * All rights reserved.</center></h2>
 *
 * This software component is licensed by ST under BSD 3-Clause license,
 * the "License"; You may not use this file except in compliance with the
 * License. You may obtain a copy of the License at:
 *                        opensource.org/licenses/BSD-3-Clause
 *
 ******************************************************************************
 */

#if !defined(__SOFT_FP__) && defined(__ARM_FP)
  #warning "FPU is not initialized, but the project is compiling for an FPU. Please initialize the FPU before use."
#endif

#include <stm32f4xx.h>

#include <stdint.h>
#include <stdbool.h>

#include <mcalGPIO.h>
#include <mcalTimer.h>

void tim8CenterAligned(void);
void tim2EdgeAligned(void);

int main(void)
{
    tim8CenterAligned();
    tim2EdgeAligned();

    while (1)
    {

    }
}

void tim8CenterAligned(void)
{
    gpioInitPort(GPIOC);
    gpioSelectPinMode(GPIOC, PIN6, ALTFUNC);
    gpioSelectAltFunc(GPIOC, PIN6, AF3);

    timerBusClkOn(TIM8);
    timerSetPrescaler(TIM8, (16 - 1));
    timerSetAutoReloadValue(TIM8, (1000 - 1));
    timerResetCounter(TIM8);
    timerSetCapCompMode(TIM8, TIMIO_CH1, TIMIO_OUTPUT, CHN_PWM_MODE_1);
    timerSelectCapCompOutType(TIM8, TIMIO_CH1, CHN_ENABLE);
    timerSetPreloadValue(TIM8, TIMIO_CH1, (300 - 1));
    timerBdtrClearRegister(TIM8);
    timerBdtrEnableMainOutput(TIM8, MOE_ON);
    TIM8->CR1 = 0x21;
}

void tim2EdgeAligned(void)
{
    gpioInitPort(GPIOA);
    gpioSelectPinMode(GPIOA, PIN5, ALTFUNC);
    gpioSelectAltFunc(GPIOA, PIN5, AF1);

    timerBusClkOn(TIM2);
    timerSetPrescaler(TIM2, (16 - 1));
    timerSetAutoReloadValue(TIM2, (1000 - 1));
    timerResetCounter(TIM2);
    timerSetCapCompMode(TIM2, TIMIO_CH1, TIMIO_OUTPUT, CHN_PWM_MODE_1);
    timerSelectCapCompOutType(TIM2, TIMIO_CH1, CHN_ENABLE);
    timerSetPreloadValue(TIM2, TIMIO_CH1, (300 - 1));
    timerStart(TIM2);
}
