/**
 ******************************************************************************
 * @file           : main.c
 * @author         : Auto-generated by STM32CubeIDE
 * @brief          : Main program body
 ******************************************************************************
 * @attention
 *
 * <h2><center>&copy; Copyright (c) 2020 STMicroelectronics.
 * All rights reserved.</center></h2>
 *
 * This software component is licensed by ST under BSD 3-Clause license,
 * the "License"; You may not use this file except in compliance with the
 * License. You may obtain a copy of the License at:
 *                        opensource.org/licenses/BSD-3-Clause
 *
 ******************************************************************************
 */

#if !defined(__SOFT_FP__) && defined(__ARM_FP)
  #warning "FPU is not initialized, but the project is compiling for an FPU. Please initialize the FPU before use."
#endif

#include <stm32f4xx.h>
#include <stdint.h>
#include <stdbool.h>

#include <mcalGPIO.h>
#include <mcalUsart.h>
#include <mcalDMAC.h>

// Prototypen
void doErrorHandling(DMAC_ERROR_CODE_t dmaStatus);

// Globale Variablen
uint8_t  msg[128];
uint16_t numData  = sizeof(msg);
bool     done     = true;

int main(void)
{
    uint16_t count;

    DMA_Stream_TypeDef *stream = DMA1_Stream5;
    DMAC_ERROR_CODE_t   dmaStatus = DMAC_OK;

    // Initialisierung von PA2/PA3 fuer USART2
    gpioInitPort(GPIOA);
    gpioSelectPinMode(GPIOA, PIN2, ALTFUNC);
    gpioSelectAltFunc(GPIOA, PIN2, AF7);            // PA2 : USART2 Tx
    gpioSelectPinMode(GPIOA, PIN3, ALTFUNC);
    gpioSelectAltFunc(GPIOA, PIN3, AF7);            // PA3 : USART2 Rx
    gpioSelectPinMode(GPIOA, PIN5, OUTPUT);         // PA5   : GPIO-Output fuer LED

    // Initialisierung von USART2. Aktiviert immer Receiver und Transmitter.
    // Aktiviert immer den Bustakt fuer den gewaehlten UART/USART.
    usartSelectUsart(USART2);
    usartEnableUsart(USART2);
    usartSetCommParams(USART2, 115200, NO_PARITY, LEN_8BIT, ONE_BIT);
    usartSetDmaRxMode(USART2, DMA_RECEIVE_ON);

    // Initialisierung des DMAC
    dmaStatus = dmacInitDMAC(DMA1);
    if (DMAC_OK != dmaStatus)
    {
        doErrorHandling(dmaStatus);
    }

    dmaStatus = dmacClearStreamIrqFlags(DMA1, stream);
    if (DMAC_OK != dmaStatus)
    {
        doErrorHandling(dmaStatus);
    }

    NVIC_EnableIRQ(DMA1_Stream5_IRQn);

    while(1)
    {
        done = false;
        dmaStatus = dmacDisableStream(stream);
        if (DMAC_OK != dmaStatus)
        {
            doErrorHandling(dmaStatus);
        }
        dmaStatus = dmacSetStreamAndChannel(stream, CHANNEL_4,
                                            (uint32_t) msg, (uint32_t) &(USART2->DR),
                                            numData,
                                            BYTE, BYTE,
                                            PER_2_MEM,
                                            TX_COMPLETE);
        if (DMAC_OK != dmaStatus)
        {
            doErrorHandling(dmaStatus);
        }

        dmaStatus = dmacEnableStream(stream);
        if (DMAC_OK != dmaStatus)
        {
            doErrorHandling(dmaStatus);
        }

        while (done == false)
        {
            // TODO: Hier Geht's weiter
            // Warte, bis 'done' true ist.
        }

        for (count = 0; count < numData; count++)
        {
            while(!(USART2->SR & USART_SR_TC))
            {
                // Warte, bis der Transfer zum USART abgeschlossen ist.
            }
            USART2->DR = msg[count];
        }
    }
}

/**
 * @brief ISR fuer DMA1/Stream6
 */
void DMA1_Stream5_IRQHandler(void)
{
    // Hier wird nur "Transfer complete" ausgewertet.
    if (DMA1->HISR & DMA_HISR_TCIF5)
    {
        DMA1->HIFCR |= DMA_HIFCR_CTCIF5;        // Reset "Transfer complete" flag
    }
    done = true;
}

/**
 * @brief Fehlerbehandlung
 */
void doErrorHandling(DMAC_ERROR_CODE_t dmaStatus)
{
    while(1)
    {
        ;
    }
}
