/**
 * Projekt Kap08-SysTick-01
 * ========================
 *
 * Ein Beispiel zum Einsatz des SysTick-Timers (das teilweise aber im Vorgriff
 * auf dieses Kapitel bereits früher verwendet wurde).
 */

/**
 ******************************************************************************
 * @file           : main.c
 * @author         : Auto-generated by STM32CubeIDE
 * @brief          : Main program body
 ******************************************************************************
 * @attention
 *
 * <h2><center>&copy; Copyright (c) 2019 STMicroelectronics.
 * All rights reserved.</center></h2>
 *
 * This software component is licensed by ST under BSD 3-Clause license,
 * the "License"; You may not use this file except in compliance with the
 * License. You may obtain a copy of the License at:
 *                        opensource.org/licenses/BSD-3-Clause
 *
 ******************************************************************************
 */

#if !defined(__SOFT_FP__) && defined(__ARM_FP)
  #warning "FPU is not initialized, but the project is compiling for an FPU. Please initialize the FPU before use."
#endif

#include <stm32f4xx.h>
#include <system_stm32f4xx.h>

#include <mcalGPIO.h>

void SysTick_Handler(void);

uint16_t tick = 0;

int main(void)
{
    // Die beiden folgenden Zeilen werden als systickInit(uint32_t divisor)
    // in MCAL aufgenommen. Fuer den Divisor werden in mcalSysTick.h
    // Konstanten eingefuehrt, die die Zeitbasis festlegen.
    SystemCoreClockUpdate();                  // SysTick: Konfig.
    SysTick_Config(SystemCoreClock / 1000);   // SysTick = 1 ms

    gpioInitPort(GPIOA);
    gpioSelectPinMode(GPIOA, PIN0, OUTPUT);
    gpioSetOutputType(GPIOA, PIN0, PUSHPULL);
    gpioSelectPushPullType(GPIOA, PIN0, PULLUP);

    while(1)
    {
    	if (tick > 499)
    	{
    		// Testet, ob PA0 auf High- oder auf Low-Level ist
    		if (gpioGetPinVal(GPIOA, PIN0))
    		{
    			gpioResetPin(GPIOA, PIN0);
    		}
    		else
    		{
    			gpioSetPin(GPIOA, PIN0);
    		}

    		tick = 0;
    	}
    }
}

/**
 * Interrupt-Service-Routine des SysTick-Timers
 */
void SysTick_Handler(void)
{
    ++tick;
}
