#include <stdio.h>
#include <stdlib.h>
#include <stdint.h>
#include <stdbool.h>

void functionA(void);
void functionB(void);
void mathInt(int a, int b);
void mathFloat(float a, float b);

void callback(void(*fptr)());

void functionA(void)
{
	printf("I am function A\n");
}

void functionB(void)
{
	printf("I am function B\n");
}

void mathInt(int a, int b)
{
	printf ("%d\n", a + b);
}

void mathFloat(float a, float b)
{
	printf ("%f\n", a + b);
}

void callback(void (*fptr)())
{
	(*fptr)();
}

void main (int argc, char **argv)
{
	void (*ptrA)() = &functionA;
	callback(ptrA);
	
	void (*ptrB)() = &functionB;
	callback(ptrB);
	
	void (*ptrMathInt) = (&mathInt)(1, 2);
	callback(ptrMathInt);
	
	void (*ptrMathFloat) = (&mathFloat)(2.0, 1.14);
	callback(ptrMathFloat);
}