/**
* @file  : main.c
* @author: Ralf Jesse
* @brief: Ermitteln des Speicherbedarfs von Variablen
*/

#include <stdint.h>
#include <stddef.h>
#include <stdlib.h>

#include <stm32f4xx.h>

int main(void)
{
                                                             // Speicherbedarf
                                                             // ==============
     size_t size = sizeof(size_t);                           // 4 Byte

     wchar_t  zeichen = 'A';
     size_t wcharSize = sizeof(zeichen);                     // 4 Byte

     uint32_t array1[] = { 0x00, 0x01, 0x02, 0x03 };
     size_t   arr1Size =
              sizeof(array1) / sizeof(array1[0]);            // 16 Byte

     uint16_t array2[] = { 0x00, 0x01, 0x02, 0x03 };
     size_t   arr2Size =
              sizeof(array2) / sizeof(array2[0]);            // 8 Byte

     uint8_t  array3[] = { 0x00, 0x01, 0x02, 0x03 };
     size_t   arr3Size = sizeof(array3) / sizeof(array3[0]); // 4 Byte

     double   doubleVar = 3.1415;
     size_t   doubleVarSize = sizeof(doubleVar);             // 8 Byte

     double   doubleArr[] = { 2.718281, 3.1415 };
     size_t   doubleArrSize =
              sizeof(doubleArr) / sizeof(doubleArr[0]);      // 16 Byte

     float    floatVar = 3.1415;
     size_t   floatVarSize = sizeof(floatVar);               // 4 Byte

     float    floatArr[] = { 2.718281, 3.1415 };
     size_t   floatArrSize =
              sizeof(floatArr) / sizeof(floatArr[0]);        // 16 Byte


     RCC->AHB1ENR |= RCC_AHB1ENR_GPIOAEN;
     GPIOA->ODR |= GPIO_ODR_OD5;

     /* Loop forever */
     for(;;);
}
